<?php
Session::init();
$ver = (Session::get('bloqueo') == 0 or Session::get('bloqueo') == null) ? '' : header('location: ' . URL . 'err/bloqueo');
?>
<?php
require_once 'public/lib/print/num_letras.php';
require_once 'api_fact/controller/api.php';
require_once 'mailer/send.php';

class Facturacion extends Controller
{

    function __construct()
    {
        parent::__construct();
        Auth::handleLogin();
    }

    function Index()
    {
        $this->view->title_page = 'Facturación Electrónica';
        $this->view->js = array('venta/js/jquery-ui.min.js', 'facturacion/js/facturacion.js');
        $this->view->render('facturacion/index', false);
    }

    function Datos1()
    {
        $this->model->Datos1($_POST);
    }

    function Datos2()
    {
        $this->model->Datos2($_POST);
    }

    function Datos3()
    {
        $this->model->Datos3($_POST);
    }

    function Datos4()
    {
        $this->model->Datos4($_POST);
    }

    function Datos5()
    {
        $this->model->Datos5($_POST);
    }

    function Detalle()
    {
        $this->model->Detalle($_POST);
    }

    // function Invoice()
    // {
    //     // $cod_ven = $_POST['cod_ven'];
    //     // $invoice = new ApiSunat();
    //     // $data = $invoice->sendDocSunaht($cod_ven, 1);

    //     require_once 'controllers/PseController.php';
    //     $pse = new PseController();
    //     $resp = $pse->enviarFactura((int) $_POST['cod_ven']);
    //     var_dump($resp);
    // }

    // function ComunicacionBaja(){
    //     var_dump("facturacion controller");
    //     var_dump($_POST);
    //     $api = new ApiSunat();
    //     $api->postComunicacionBaja($_POST);
    // }

    function Invoice()
    {
        header('Content-Type: application/json; charset=UTF-8');
        // (Opcional CORS)
        // header('Access-Control-Allow-Origin: *');
        // header('Access-Control-Allow-Methods: POST, OPTIONS');
        // if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

        try {
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                http_response_code(405);
                echo json_encode(['ok' => false, 'message' => 'Método no permitido']);
                return;
            }

            $codVen = filter_input(INPUT_POST, 'cod_ven', FILTER_VALIDATE_INT);
            if (!$codVen) {
                http_response_code(422);
                echo json_encode(['ok' => false, 'message' => 'cod_ven es requerido y debe ser entero']);
                return;
            }

            require_once 'controllers/PseController.php';
            $pse = new PseController();
            $resp = $pse->enviarFactura((int) $codVen);

            // Si tu enviarFactura() ya devuelve ['ok'=>bool,'http'=>int,...]
            $isOk = !empty($resp['ok']);
            $status = (int) ($resp['http'] ?? ($isOk ? 200 : 500));

            // Normaliza códigos de error del PSE hacia 4xx/5xx
            if (!$isOk && ($status < 400 || $status > 599)) {
                $status = 400;
            }
            http_response_code($status);

            if ($isOk) {
                // Payload compacto para el front
                echo json_encode([
                    'ok' => true,
                    'message' => $resp['mensaje'] ?? 'Emitido correctamente',
                    'hash_cpe' => $resp['hash_cpe'] ?? null,
                    'hash_cdr' => $resp['hash_cdr'] ?? null,
                    'files' => [
                        'zip_cpe_url' => $resp['zip_cpe_url'] ?? null,
                        'zip_cdr_url' => $resp['zip_cdr_url'] ?? null,
                        'zip_cpe_local' => $resp['zip_cpe_local'] ?? null, // por si tu front es interno
                        'zip_cdr_local' => $resp['zip_cdr_local'] ?? null,
                    ],
                    'rutas_api' => $resp['rutas_api'] ?? null, // ruta_xml, ruta_pdf, etc. si las expone el PSE
                ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            } else {
                // No expongas demasiada info en prod; deja 'debug' para staging
                echo json_encode([
                    'ok' => false,
                    'message' => $resp['mensaje']
                        ?? $resp['error']
                        ?? ($resp['response_json']['mensaje'] ?? 'Error al emitir'),
                    'http' => $status,
                    'debug' => [
                        'request' => $resp['request_json'] ?? null,
                        'response' => $resp['response_raw'] ?? null,
                    ],
                ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            }

        } catch (Throwable $e) {
            http_response_code(500);
            echo json_encode(['ok' => false, 'message' => $e->getMessage()]);
        }
    }


    function ComunicacionBaja()
    {
        require_once 'controllers/PseController.php';

        // Siempre responde JSON
        header('Content-Type: application/json; charset=utf-8');

        try {
                        
            // Validar método y payload
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                http_response_code(405); // Method Not Allowed
                echo json_encode(['ok' => false, 'error' => 'Método no permitido']);
                return;
            }

            $post = $_POST ?? [];
            
            if (empty($post) || !isset($post['id_venta'])) {
                http_response_code(400);
                echo json_encode(['ok' => false, 'error' => 'Faltan parámetros (id_venta)']);
                return;
            }

            $id_venta = (int) $post['id_venta'];
            if ($id_venta <= 0) {
                http_response_code(400);
                echo json_encode(['ok' => false, 'error' => 'id_venta inválido']);
                return;
            }

            $pse = new PseController();

            $resp = $post['tipo_doc'] == "1" ? $pse->comunicacionBaja($id_venta) : $pse->resumenBoleta($id_venta);

            if (!is_array($resp)) {
                // Defensa: si por alguna razón no vuelve array
                http_response_code(500);
                echo json_encode(['ok' => false, 'error' => 'Respuesta interna inválida']);
                return;
            }

            if (!empty($resp['ok'])) {
                // Éxito
                http_response_code(200);
                echo json_encode([
                    'ok' => true,
                    'http' => $resp['http'] ?? 200,
                    'ticket' => $resp['ticket'] ?? null,
                    'cod_sunat' => $resp['cod_sunat'] ?? null,
                    'mensaje' => $resp['mensaje'] ?? null,
                    'hash_cpe' => $resp['hash_cpe'] ?? null,
                    'hash_cdr' => $resp['hash_cdr'] ?? null,
                    // Si quieres entregar rutas para que el front descargue:
                    'zip_cpe_url' => $resp['zip_cpe_url'] ?? null,
                    'zip_cdr_url' => $resp['zip_cdr_url'] ?? null,
                    // Quita 'raw' en producción si no lo necesitas
                ], JSON_UNESCAPED_UNICODE);
                return;
            }

            // Error controlado desde el servicio
            http_response_code(400);
            echo json_encode([
                'ok' => false,
                'error' => $resp['error'] ?? 'Error desconocido'
            ], JSON_UNESCAPED_UNICODE);

        } catch (\Throwable $e) {
            http_response_code(500);
            echo json_encode(['ok' => false, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
        }
    }

    // function ComunicacionBaja()
    // {
    //     require_once 'controllers/PseController.php';
    //     $pse = new PseController();
    //     $post = $_POST ?? [];
    //     if (empty($post) || !isset($post['id_venta'])) {
    //         http_response_code(400);
    //         echo json_encode(['ok' => false, 'error' => 'Faltan parámetros (id_venta)']);
    //         return;
    //     }

    //     $id_venta = (int) $post['id_venta'];
    //     if ($id_venta <= 0) {
    //         http_response_code(400);
    //         echo json_encode(['ok' => false, 'error' => 'id_venta inválido']);
    //         return;
    //     }

    //     $pse = new PseController();
    //     $resp = $post['tipo_doc'] == "1" ? $pse->comunicacionBaja($id_venta) : $pse->resumenBoleta($id_venta);
    //     var_dump($resp);
    // }


    function reenvio()
    {
        $this->model->reenvio($_POST);
        print_r(json_encode(1));
    }

    function cambioFecha()
    {
        $this->model->cambioFecha($_POST);
        print_r(json_encode(1));
    }

    function Resumen_boletas()
    {
        $api = new ApiSunat();
        $api->postResumenDiario($_POST);
    }

    function send_mailer()
    {
        $negocio = "" . NAME_NEGOCIO . "";
        $server_smtp = "" . SERVER_SMTP . "";
        $email_smtp = "" . EMAIL_SMTP . "";
        $pass_smtp = "" . PASS_SMTP . "";
        $datos_factura = $this->model->pdf_factura($_POST['id_venta']);
        $api = new Email();
        // echo $_POST['id_venta'];
        // return;
        $api->sendEmail($_POST['correo_cliente'], $_POST['documento_cliente'], $_POST['n_documento_cliente'], json_encode($datos_factura), $negocio, $server_smtp, $email_smtp, $pass_smtp);
    }

}