$(function() {
    var id_catg = '%';
    listarCategorias();
    listarProductos(id_catg);
    $('.scroll_categoria').slimscroll({
        height: '100%'
    });
    var scroll_categoria = function () {
            var topOffset = 340;
            var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
            height = height - topOffset;
            $(".scroll_categoria").css("height", (height) + "px");
    };
    $(window).ready(scroll_categoria);
    $(window).on("resize", scroll_categoria);

    $('.scroll_receta').slimscroll({
        // height: '100%'
    });
    var scroll_receta = function () {
            var topOffset = 260;
            var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
            height = height - topOffset;
            $(".scroll_receta").css("height", (height) + "px");
    };
    $(window).ready(scroll_receta);
    $(window).on("resize", scroll_receta);
});

var obtenerFecha = function (d) {
      d = new Date(d);
      var day = d.getDay(),
          diff = d.getDate() - day + (day == 0 ? -6:1); 

      return new Date(d.setDate(diff));
    }

var exportTableToExcel = function(tableID, filename = ''){
    var downloadLink;
    var dataType = 'application/vnd.ms-excel';
    var tableSelect = document.getElementById(tableID);
    var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
    
    fecha = obtenerFecha(new Date()).toISOString().substring(0, 10)

    filename = 'receta_'+$("#btnExcel").attr("receta")+'_'+fecha+'.xls';
    filename = filename.toLowerCase().replace(/ /g,"_")
   
    downloadLink = document.createElement("a");
    
    document.body.appendChild(downloadLink);
    
    if(navigator.msSaveOrOpenBlob){
        var blob = new Blob(['ufeff', tableHTML], {
            type: dataType
        });
        navigator.msSaveOrOpenBlob( blob, filename);
    }else{
        downloadLink.href = 'data:' + dataType + ', ' + tableHTML;
        downloadLink.download = filename;
        downloadLink.click();
    }
}

/* Mostrar datos en la lista categorias */ 
var listarCategorias = function(){
    $('#ul-cat').empty();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_cat_list",
        dataType: "json",
        success: function(item){
            // alert(item)
            $('#ul-cat')
                .append(
                $('<li class="nav-item" style="font-size: 13px; width: 100%!important">')
                    .html('<a href="javascript:void(0)" class="nav-link active" data-toggle="list" href="javascript:void(0)" onclick="listarProductos(\'%\')">Todos</a>')
                )
            if(item.data.length > 0){
                $.each(item.data, function(i, campo) {
                    $('#ul-cat')
                        .append(
                        $('<li class="nav-item" style="font-size: 13px; width: 100%!important">')
                            .html('<a href="javascript:void(0)" class="nav-link" data-toggle="list" href="javascript:void(0)" onclick="listarProductos('+campo.id_catg+')">'+campo.descripcion+''
                            +'<span style="float:right"><i data-feather="edit" class="feather-sm fill-white" onclick="editarCategoria('+campo.id_catg+',\''+campo.descripcion+'\','+campo.delivery+','+campo.orden+',\''+campo.estado+'\',\''+campo.imagen+'\')"></i>'
                            +'&nbsp;<i data-feather="trash-2" class="feather-sm fill-white" onclick="eliminarCategoria('+campo.id_catg+')"></i>&nbsp;</span></a>')
                        )
                });
                feather.replace();
            }else{
                $('#ul-cat').html("<center><br><br><br><i class='mdi mdi-alert-circle display-3' style='color: #d3d3d3;'></i><br><br><span class='font-18' style='color: #d3d3d3;'>No hay datos disponibles</span><br></center>");
            }
        }
    });
}

/* Mostrar datos en la tabla productos */
var listarProductos = function(id_catg){
    $('#categoria').val(id_catg);
    $('#head-p').empty();
    $('#body-c').empty();
    $('#sinPres').css("display", "block");
    $('#conPres').css("display", "none");
    // $('#body-p').html('<div class="row text-center"><div class="col-sm-10 offset-sm-1"><h4><i class="ti ti-arrow-circle-left"></i><br>Agregue o seleccione un producto</h4><h6>Debes agregar o seleccionar un producto para poder agregar o modificar sus presentaciones</h6></div></div>');
    var table = $('#table-productos')
    .DataTable({
        "destroy": true,
        "responsive": true,
        "dom": "tp",
        "bSort": false,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"ajuste/producto_list",
            "data": {
                id_prod : '%',
                id_catg : id_catg
            }
        },
        "columns":[
            {"data":null,"render": function ( data, type, row) {
                return '<a href="javascript:void(0)" class="link" onclick="listarPresentaciones('+data.id_prod+',\''+data.nombre+'\')">'+data.nombre+'</a>';
            }},
            {"data":null,"render": function ( data, type, row) {
                    return '<div class="text-center">'+data.areaprod+'</div>';
            }},
            {"data":null,"render": function ( data, type, row) {
                if(data.id_tipo == 1){
                    return '<div class="text-center"><span class="text-navy"><i class="ti-check"></i> Si </span></div>';
                } else if (data.id_tipo == 2){
                    return '<div class="text-center"><span class="text-danger"><i class="ti-close"></i> No </span></div>'
                }
            }},
            {"data":null,"render": function ( data, type, row) {
                if(data.estado == 'a'){
                    return '<div class="text-center"><span class="text-navy"><i class="ti-check"></i> Si </span></div>';
                } else if (data.estado == 'i'){
                    return '<div class="text-center"><span class="text-danger"><i class="ti-close"></i> No </span></div>'
                }
            }},
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="text-right"><a href="javascript:void(0)" class="text-info edit" onclick="editarProducto('+data.id_prod+')"><i data-feather="edit" class="feather-sm fill-white"></i></a><a href="javascript:void(0)" class="text-danger edit" onclick="eliminarProducto('+data.id_prod+')"><i data-feather="trash-2" class="feather-sm fill-white"></i></a></div>';
            }}
        ]
    });

    $('#table-productos').DataTable().on("draw", function(){
        feather.replace();
    });
}

/* Listar presentaciones de cada producto seleccionado */
var listarPresentaciones = function(id_prod,nombre){
    
    var moneda = $("#moneda").val();
    var id_pres = '%';
    $('#sinPres').css("display", "none");
    $('#conPres').css("display", "block");
    
    //$('#head-p').html('<button class="btn btn-success btn-block btn-nuevo-presentacion" onclick="nuevaPresentacion('+id_prod+',\''+nombre+'\')"><i class="fas fa-plus-circle"></i> Agregar presentación </button>');
    $('#body-c').html('<br><strong class="text-warning">Presentaciones de <span id="nomb_pres">'+nombre+'</span></strong>');
    console.log(id_prod,id_pres);
    var table = $('#table-presentaciones').DataTable({
  "destroy": true,
  "responsive": true,
  "dom": "tp",
  "bSort": false,
  "ajax": {
    "method": "POST",
    "url": $('#url').val()+"ajuste/producto_pres_list",
    "data": { id_prod: id_prod, id_pres: id_pres },
    "dataSrc": function (json) {
        
      // ✅ Validación si el arreglo viene vacío
      if (!json.data || json.data.length === 0) {
        $('#head-p').html(
          '<button class="btn btn-success btn-block btn-nuevo-presentacion" onclick="nuevaPresentacion(' + id_prod + ',\'' + nombre + '\')">' +
          '<i class="fas fa-plus-circle"></i> Agregar presentación </button>'
        );
      }
      return json.data; // importante para que la tabla se renderice
    }
  },
  "createdRow": function (row, data, dataIndex) {
    if (data.estado != 'a') {
      $(row).addClass('boxpres');
    }
  },
  "columns": [
    {
      "data": null,
      "render": function (data, type, row) {
          $('#head-p').html('<button class="btn btn-success btn-block btn-nuevo-presentacion" onclick="nuevaPresentacion('+data.id_prod+',\''+nombre+'\')"><i class="fas fa-plus-circle"></i> Agregar presentación </button>');
        return '<a href="javascript:void(0)" class="link" onclick="editarPresentacion(' + data.id_pres + ',\'' + nombre + '\')">' + data.presentacion + ' - ' + data.cod_prod + '</a>';
      }
    },
    {
      "data": null,
      "render": function (data, type, row) {
        return data.favorito == 1 ? '<div class="text-danger text-center"><i class="fa fa-heart"></i></div>' : '';
      }
    },
    {
      "data": null,
      "render": function (data, type, row) {
        return '<a href="javascript:void(0)" class="link" onclick="editarPresentacion(' + data.id_pres + ',\'' + nombre + '\')">' + moneda + ' ' + data.precio + '</a>';
      }
    },
    {
      "data": null,
      "render": function (data, type, row) {
        return '<a href="javascript:void(0)" class="text-danger edit" onclick="eliminarPres(' + data.id_pres + ')"><i data-feather="trash-2" class="feather-sm fill-white"></i></a>';
      }
    }
  ]
});

    $('#table-presentaciones').DataTable().on("draw", function(){
        feather.replace();
    });

}

/* Editar datos de un producto */
var editarProducto = function(id_prod){
    $('.bootstrap-tagsinput').css('display','block');
    $('#id_catg_producto').find('option').remove();
    ComboCatg();
    var id_catg = '%';
    $('#modal-producto').modal('show');
    $("#id_prod_producto").val(id_prod);
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_list",
        data: {
            id_prod: id_prod,
            id_catg: id_catg
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {
                $('#notas_producto').tagsinput('removeAll');
                $('#nombre_producto').val(campo.nombre);
                if(campo.id_tipo == 1){
                    $('#transf').addClass('active');
                    $('#ntransf').removeClass('active');
                    $("input[name=id_tipo][value='1']").attr("checked",true);
                    $("input[name=id_tipo][value='2']").attr("checked",false);
                } else if (campo.id_tipo == 2){
                    $('#ntransf').addClass('active');
                    $('#transf').removeClass('active');
                    $("input[name=id_tipo][value='1']").attr("checked",false);
                    $("input[name=id_tipo][value='2']").attr("checked",true);
                }
                if(campo.delivery == 1){
                    $('#delivery_producto').prop('checked', true);
                    $('#hidden_delivery_producto').val(1);
                } else {
                    $('#delivery_producto').prop('checked', false);
                    $('#hidden_delivery_producto').val(0);
                }
                if(campo.estado == 'a'){
                    $('#estado_producto').prop('checked', true);
                    $('#hidden_estado_producto').val('a');
                } else {
                    $('#estado_producto').prop('checked', false);
                    $('#hidden_estado_producto').val('i');
                }
                $('#id_areap_producto').selectpicker('val', campo.id_areap);
                $('#id_catg_producto').selectpicker('val', campo.id_catg);
                $('#id_catg_producto').selectpicker();
                $('#id_catg_producto').selectpicker('refresh');
                $('#notas_producto').tagsinput('add',campo.notas);
                //$('#descripcion_producto').val(campo.descripcion);
            });
        }
    });
}

/* Editar categoria */
var editarCategoria = function(id_catg,descripcion,delivery,orden,estado,imagen){
    $(".f").addClass("focused");
    $("#id_catg_categoria").val(id_catg);
    $("#descripcion_categoria").val(descripcion);
    $("#orden_categoria").val(orden);
    $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/productos/'+imagen+'');
    $('#imagen').val(imagen);
    $('#wizard-picture-2').val('');
    $('.display-categoria-list').hide();
    $('#display-categoria-nuevo').show();
    $('#form-categoria').formValidation('revalidateField', 'descripcion_categoria');
    if(delivery == 1){
        $('#delivery_categoria').prop('checked', true);
        $('#hidden_delivery_categoria').val(1);
    } else {
        $('#delivery_categoria').prop('checked', false);
        $('#hidden_delivery_categoria').val(0);
    }
    if(estado == 'a'){
        $('#estado_categoria').prop('checked', true);
        $('#hidden_estado_categoria').val('a');
    } else {
        $('#estado_categoria').prop('checked', false);
        $('#hidden_estado_categoria').val('i');
    }
}

/* Eliminar categoria */
var eliminarCategoria = function(id_catg){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_cat_delete",
        data: {
            id_catg: id_catg
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                listarCategorias();
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}

/* Eliminar Producto */
var eliminarProducto = function(id_producto){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_prod_delete",
        data: {
            id_prod: id_producto
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                var id_catg = '%';
                listarCategorias();
                listarProductos(id_catg);
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}

/* Eliminar Presentacion */
var eliminarPres = function(id_pres){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_pres_delete",
        data: {
            id_pres: id_pres
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                var id_catg = '%';
                listarCategorias();
                listarProductos(id_catg);
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}


/* Nueva presentacion de un producto */ 
var nuevaPresentacion = function(id_prod,nombre){
    $(".f").removeClass("focused");
    $('#form-presentacion').formValidation('resetForm', true);
    $('#wizardPicturePreview').attr('src',$("#url").val()+'public/images/productos/default.png');
    $('#imagen2').val('default.png');
    $('#wizard-picture').val('');
    $('#id_prod_presentacion').val(id_prod);
    $('#nombre_producto_presentacion').val(nombre);
    $('#cod_prod_presentacion').val('');
    $('#descripcion_presentacion').val('');
    $('#precio_presentacion2').val('0.00');
    $('#precio_presentacion_compra').val('0.00');
    $('#stock_min_presentacion').val('');
    $('#ordenins').val('1');
    $('#precio_delivery').val('');
    var id_catg = '%';
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_list",
        data: {
            id_prod: id_prod,
            id_catg: id_catg
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {
            //id_tipo = 1 (Producto Transformado)
                if(campo.id_tipo == 1){
                    // Ocultar check receta (tp-1), stock/stock_minimo (tp-2)
                    $('#tp-1').css('display','none');
                    $('#tp-2').css('display','block');
                    $('#tp-4').css('display','none');
                    // Quita el check a receta
                    $('#receta_presentacion').prop('checked', false);
                    $('#mensaje-ins').css('display','block');
                    $('#mensaje-ins').html('<div class="alert alert-warning">'
                        +'Guarde los datos de la presentaci&oacute;n, para que pueda ingresar una receta'
                        +'</div>');
                }
                //id_tipo = 2 (Producto NO Transformado)
                else{
                    $('#stock_presentacion').prop('checked', false);
                    $('#mensaje-ins').css('display','none');
                    // Ocultar check receta (tp-1)
                    $('#tp-1').css('display','none');
                    // Mostrar check stock / stock-minimo (tp-2)
                    $('#tp-2').css('display','block');
                    $('#tp-4').css('display','none');
                }
                $('#tp-5').css('display','none');
                $('#hidden_receta_presentacion').val(0);
                $('#hidden_impuesto_presentacion').val(1);
                $('#impuesto_presentacion').prop('checked', true);
                $('#hidden_impuesto_presentacion_compra').val(0);
                $('#impuesto_presentacion_compra').prop('checked', false);
                $('#hidden_estado_presentacion').val('a');
                $('#hidden_favorito').val(0);
                $('#favorito').prop('checked', false);
                $('#estado_presentacion').prop('checked', true);
                $('#hidden_delivery_presentacion').val(0);
                $('#delivery_presentacion').prop('checked', false);
                $('#hidden_impuesto_icbper').val(0);
                $('#impuesto_icbper').prop('checked', false);
                $('#hidden_insumo_principal_presentacion').val(0);
                $('#insumo_principal_presentacion').prop('checked', false);
                $('#tp-3').css('display','none');
            });
        }
    });
    $('#id_pres_presentacion').val('');
    $('#modal-presentacion').modal('show');
}

/* Editar datos de una presentacion de un producto */
var editarPresentacion = function(id_pres,nombre){
    $(".f").addClass("focused");
    var id_prod = '%';
    $('#form-presentacion').formValidation('resetForm', true);
    $("#nombre_producto_presentacion").val(nombre);
    $('#id_pres_receta').val(id_pres);
    $('#modal-presentacion').modal('show');
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_pres_list",
        data: {
            id_prod: id_prod,
            id_pres: id_pres
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {
                $('#id_pres_presentacion').val(campo.id_pres);
                $('#id_prod_presentacion').val(campo.id_prod);
                $('#cod_prod_presentacion').val(campo.cod_prod);
                $('#presentacion_presentacion').val(campo.presentacion);
                $('#descripcion_presentacion').val(campo.descripcion);
                $('#precio_presentacion').val(campo.precio);
                $('#ordenins').val(campo.ordenins);
                $('.nomProductoPres').html(nombre+' '+campo.presentacion);
                $("#btnExcel").attr("receta",nombre+' '+campo.presentacion);
                $('#precio_presentacion2').val(campo.precio2);
                $('#precio_presentacion_compra').val(campo.precio_compra);
                $('#precio_delivery').val(campo.precio_delivery);
                $('#wizardPicturePreview').attr('src',$("#url").val()+'public/images/productos/'+campo.imagen+'');
                $('#imagen2').val(campo.imagen);
                $('#wizard-picture').val('');
                $('#stock_min_presentacion').val(campo.stock_min);

                $('#procesoGuardarPrecio').css("display", "none");
                $(".tb_precios tbody").html('')
                limpiarInputPrecio()
                if (campo.precios.length > 0) {
                    $.each(JSON.parse(campo.precios), function(e, campo22) {

                        precio = parseFloat(campo22.precio)
                        
                        var data = "\
                        <tr>\
                            <td>" + campo22.nombre + "</td>\
                            <td>" + precio.toFixed(2) + "</td>\
                            <td class='text-center'><button class='btn btn-outline-danger btn-sm' type='button' onclick='borrar_(this)'><i class='fa fa-trash text-danger'></i></button></td>\
                        </tr>";
                        $(".tb_precios tbody").append(data);
                    });
                }
                if(campo.crt_stock == 1){
                    $('#stock_limit').prop('checked', true);
                    $('#stock_presentacion').prop('checked', true);
                    $('#hidden_stock_limit').val(1);
                    $('#tp-4').css('display','block');
                    $('#tp-4-1').css('display','block');
                } else {
                    $('#stock_presentacion').prop('checked', false);
                    $('#stock_limit').prop('checked', false);
                    $('#hidden_stock_limit').val(0);
                }
                if(campo.impuesto_icbper == 1){
                    $('#impuesto_icbper').prop('checked', true);
                    $('#hidden_impuesto_icbper').val(campo.impuesto_icbper);
                    $('#tp-5').css('display','block');
                }
                if(campo.margen == 1){
                    $('#insumo_principal_presentacion').prop('checked', true);
                    $('#hidden_insumo_principal_presentacion').val(1);
                } else {
                    $('#insumo_principal_presentacion').prop('checked', false);
                    $('#hidden_insumo_principal_presentacion').val(0);
                }

                if(campo.impuesto == 1){
                    $('#impuesto_presentacion').prop('checked', true);
                    $('#hidden_impuesto_presentacion').val(1);
                } else {
                    $('#impuesto_presentacion').prop('checked', false);
                    $('#hidden_impuesto_presentacion').val(0);
                }
                if(campo.impuesto_compra == 1){
                    $('#impuesto_presentacion_compra').prop('checked', true);
                    $('#hidden_impuesto_presentacion_compra').val(1);
                } else {
                    $('#impuesto_presentacion_compra').prop('checked', false);
                    $('#hidden_impuesto_presentacion_compra').val(0);
                }

                if(campo.delivery == 1){
                    $('#delivery_presentacion').prop('checked', true);
                    $('#hidden_delivery_presentacion').val(1);
                    $('#tp-3').css('display','block');
                } else {
                    $('#delivery_presentacion').prop('checked', false);
                    $('#hidden_delivery_presentacion').val(0);
                    $('#tp-3').css('display','none');
                }

                if(campo.estado == 'a'){
                    $('#estado_presentacion').prop('checked', true);
                    $('#hidden_estado_presentacion').val('a');
                } else {
                    $('#estado_presentacion').prop('checked', false);
                    $('#hidden_estado_presentacion').val('i');
                }

                if(campo.favorito == 1){
                    $('#favorito').prop('checked', true);
                    $('#hidden_favorito').val(1);
                } else {
                    $('#favorito').prop('checked', false);
                    $('#hidden_favorito').val(0);
                }

                //id_tipo = 1 (Producto Transformado)
                if(campo.TipoProd.id_tipo == 1){
                    if(campo.receta == 1){
                        $('#receta_presentacion').prop('checked', true);
                        $('#hidden_receta_presentacion').val(1);
                        $('#mensaje-ins').css('display','block');
                        $('#mensaje-ins').html('<div class="alert alert-info">'
                            +'Modificar los ingredientes <a class="alert-link" onclick="receta()">AQUI</a>'
                            +'</div>');
                    } else {
                        $('#receta_presentacion').prop('checked', false);
                        $('#hidden_receta_presentacion').val(0);
                        $('#mensaje-ins').css('display','none');
                        $('#mensaje-ins').html('<div class="alert alert-warning">'
                            +'Ingresar los ingredientes <a class="alert-link" onclick="receta()">AQUI</a> y luego click en Guardar'
                            +'</div>');
                    }
                    // Mostrar check receta (tp-1)
                    $('#tp-1').css('display','block');
                    // Ocultar check stock / stock_minimo (tp-2)
                    $('#tp-2').css('display','block');
                    // $('#tp-4').css('display','none');
                }
                //id_tipo = 2 (Producto NO Transformado)
                else{
                    $('#mensaje-ins').css('display','none');
                    if(campo.receta == 1){
                        $('#stock_presentacion').prop('checked', true);
                        $('#tp-4').css('display','block');
                        $('#3').val(1);
                    } else {
                        $('#stock_presentacion').prop('checked', false);
                        // $('#tp-4').css('display','none');
                        $('#hidden_receta_presentacion').val(0);
                    }
                    // Ocultar check receta (tp-1)
                    $('#tp-1').css('display','none');
                    // Mostrar check stock / stock_minimo (tp-2)
                    $('#tp-2').css('display','block');
                }
            });
        }
    });
}

/* Producto */
$(function() {
    $('#form-producto')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
    })
    .on('success.form.fv', function(e) {

            e.preventDefault();
            var $form = $(e.target),
            fv = $form.data('formValidation');
            
            var form = $(this);

            var producto = {
                id_prod: 0,
                id_tipo: 0,
                id_catg: 0,
                id_areap: 0,
                nombre: 0,
                notas: 0,
                descripcion: 0,
                delivery: 0,
                estado: 0
            }

            producto.id_prod = $('#id_prod_producto').val();
            producto.id_tipo = $('input:radio[name=id_tipo]:checked').val();
            producto.id_catg = $('#id_catg_producto').val();
            producto.id_areap = $('#id_areap_producto').val();
            producto.nombre = $('#nombre_producto').val();
            producto.notas = $('#notas_producto').val().toUpperCase();
            //producto.descripcion = $('#descripcion_producto').val();
            producto.delivery = $('#hidden_delivery_producto').val();
            producto.estado = $('#hidden_estado_producto').val();

            $.ajax({
                dataType: 'JSON',
                type: 'POST',
                url: $('#url').val()+'ajuste/producto_crud',
                data: producto,
                success: function (cod) {
                    if(cod == 0){
                        Swal.fire({   
                            title:'Proceso No Culminado',   
                            text: 'Datos duplicados',
                            icon: "error", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                    } else if(cod == 1){
                        $('#modal-producto').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos registrados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarProductos(producto.id_catg);                        
                    } else if(cod == 2) {
                        $('#modal-producto').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarProductos(producto.id_catg);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }   
            });

            return false;
    });
});

$(function() {
    $('#form-presentacion')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
        })
    .on('success.form.fv', function(e) {

        e.preventDefault();

        if (parseFloat($('#precio_presentacion').val())  < parseFloat($('#precio_presentacion_compra').val()) ) {
            Swal.fire({   
                title:'Proceso No Culminado',   
                text: 'Precio de venta no puede ser menor que precio de compra.',
                icon: "error", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            return false
        }

        var $form = $(e.target),
        fv = $form.data('formValidation');
        var form = $(this);

        var presentacion = new FormData($('#form-presentacion')[0]);

        console.log(presentacion);
        

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            data: presentacion,
            url: $('#url').val()+'ajuste/producto_pres_crud',
            contentType: false,
            processData: false,
            success: function (data) {
                console.log(data);
                
                if(data.cod == 0){
                    Swal.fire({   
                        title:'Proceso No Culminado',   
                        text: 'Datos duplicados',
                        icon: "error", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                } else if(data.cod == 1){
                    $('#modal-presentacion').modal('hide');
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos registrados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                    listarPresentaciones($('#id_prod_presentacion').val(),$('#nombre_producto_presentacion').val());
                } else if(data.cod == 2) {
                    $('#modal-presentacion').modal('hide');
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos actualizados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                    listarPresentaciones($('#id_prod_presentacion').val(),$('#nombre_producto_presentacion').val());
                }
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(errorThrown + ' ' + textStatus);
            }   
        });

        return false;

      });
});

$(function() {

    $('#form-categoria')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
        }
    })

    .on('success.form.fv', function(e) {

        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
        var form = $(this);

        var categoria = new FormData($('#form-categoria')[0]);

        /*
        var categoria = {
            id_catg: 0,
            descripcion: 0,
            delivery: 0,
            estado: 0
        }

        categoria.id_catg = $('#id_catg_categoria').val();
        categoria.descripcion = $('#descripcion_categoria').val();
        categoria.delivery = $('#hidden_delivery_categoria').val();
        categoria.estado = $('#hidden_estado_categoria').val();
        */

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: $('#url').val()+'ajuste/producto_cat_crud',
            data: categoria,
            contentType: false,
            processData: false,
            success: function (cod) {
                if(cod == 0){
                    Swal.fire({   
                        title:'Proceso No Culminado',   
                        text: 'Datos duplicados',
                        icon: "error", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                } else if(cod == 1){
                    var cat = '%';
                    listarCategorias();
                    listarProductos(cat);
                    $('#descripcion_categoria').val('');
                    $("#id_catg_categoria").val('');
                    //$('#boton-catg').css("display","block");
                    $('.display-categoria-list').show();
                    $('#display-categoria-nuevo').hide();
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos registrados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                } else if(cod == 2) {
                    var cat = '%';
                    listarCategorias();
                    listarProductos(cat);
                    $('#descripcion_categoria').val('');
                    $("#id_catg_categoria").val('');
                    //$('#boton-catg').css("display","block");
                    $('.display-categoria-list').show();
                    $('#display-categoria-nuevo').hide();
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos actualizados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                }
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(errorThrown + ' ' + textStatus);
            }   
        });

    return false;

    });
});
/* import */
$(function() {
    $('#form-import')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
    })
    .on('success.form.fv', function(e) {

        if (e.type == "submit") {
            e.preventDefault();
            var $form = $(e.target),
            fv = $form.data('formValidation');
            
            var form = $(this);
        }
            var id_catg = '%';

            var formData = new FormData();
            formData.append('file', $('#upfile')[0].files[0])

            $.ajax({
                type: 'POST',
                url: $('#url').val()+'ajuste/importarexcel',
                data: formData,
                processData: false,  // tell jQuery not to process the data
                contentType: false,   // tell jQuery not to set contentType
                success: function (cod) {
                    if(cod == 0){
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso No Culminado',   
                            text: 'Datos duplicados',
                            icon: "error", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarCategorias();
                        listarProductos(id_catg);
                    } else if(cod == 1){
                  
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos registrados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarCategorias();
                        listarProductos(id_catg);
                        // listarProductos(producto.id_catg);                        
                    } else if(cod == 2) {
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        // listarProductos(producto.id_catg);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }   
            });

            return false;
    });
});

var listarReceta = function(){
    $('#table-receta').empty();
    $.ajax({
        type: "post",
        dataType: "json",
        data: {
            id_pres: $("#id_pres_receta").val()
        },
        url: $('#url').val()+'ajuste/producto_pres_ing',
        success: function (data){
            if(data.length > 0){
                var total_receta = 0
                var total_items = 0
                let principal = '';
                $.each(data, function(i, item) {
                    var opc_m=item.id_med;
                    if(1==opc_m)var valor_cant=(1*item.cant).toFixed(6);
                    else if(2==opc_m)var valor_cant=(1*item.cant).toFixed(6);
                    else if(3==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);
                    else if(4==opc_m)var valor_cant=(1e6*item.cant).toFixed(6);
                    else if(5==opc_m)var valor_cant=(1*item.cant).toFixed(6);
                    else if(6==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);
                    else if(7==opc_m)var valor_cant=(2.20462*item.cant).toFixed(6);
                    else if(8==opc_m)var valor_cant=(33.814*item.cant).toFixed(7);
                    if(item.id_tipo_ins == 1){
                        var tipo = '<span class="label label-warning">INSUMO</span>';
                    } else if (item.id_tipo_ins == 2){
                        var tipo = '<span class="label label-info">PRODUCTO</span>';
                    } else{
                        var tipo = '<span class="label label-success">COMBO</span>';
                    }

                    principal = item.ingrediente_principal === "si"
                    ? '<span class="label label-success">SI</span>'
                    : '<span class="label label-danger">NO</span>';

                    
                    var costo_prod = parseFloat(valor_cant) * parseFloat(item.Insumo.precio_compra)
                    total_receta += parseFloat(costo_prod)
                    total_items += 1
                    $('#table-receta')
                    .append(
                      $('<tr class="active"/>')
                        .append($('<td/>').html(tipo))
                        .append($('<td/>').html(item.Insumo.ins_cat))
                        .append($('<td/>').html(item.Insumo.ins_nom))
                        .append($('<td/>').html(valor_cant))
                        .append($('<td/>').html(item.Medida.descripcion))
                        .append($('<td/>').html(formatNumber(item.Insumo.precio_compra)))
                        .append($('<td/>').html(formatNumber(costo_prod)))
                        .append($('<td/>').html(principal))
                        .append($('<td class="text-right"/>').html('<div class="text-right"><a href="javascript:void(0)" class="text-danger delete ms-2" onclick="eliminarInsumo('+item.id_pi+');"><i data-feather="trash-2" class="feather-sm fill-white"></i></a></div>'))
                        )
                });
                $('#total_receta').html(formatNumber(total_receta))
                $('#total_items').html(total_items)
                feather.replace();
            } else {
                $('#table-receta').html("<tr style='border-left: 1px solid #fff;'><td colspan='6'><center><br><br><i class='fas fa-lemon display-5' style='color: #d3d3d3;'></i><br><span class='font-18' style='color: #d3d3d3;'>Agregue ingredientes</span><br><span style='color: #d3d3d3;'>No se encontraton ingredientes en esta receta</span><br></center></td></tr>");
            }
        }
    });
}

var ComboCatg = function(){
    $('#id_catg_producto').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_combo_cat",
        dataType: "json",
        success: function(data){
            $.each(data, function (index, value) {
                $('#id_catg_producto').append("<option value='" + value.id_catg + "'>" + value.descripcion + "</option>");            
                $('#id_catg_producto').selectpicker();
                $('#id_catg_producto').selectpicker('refresh');
                $('#id_catg_producto').selectpicker('val', $('#categoria').val());
                $('#id_catg_producto').selectpicker('refresh');    
            });
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        } 
    });
    
}

/* Abrir modal para ingresar insumos/ingredientes a la receta */
var receta = function(){
    $('#modal-presentacion').modal('hide');
    $('#modal-receta').modal('show');
    $('.list-ingredientes').css('display','none');
    listarReceta();
}

/* Eliminar insumo/ingrediente de receta */
var eliminarInsumo = function(id_pi){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_ingrediente_delete",
        data: {
            id_pi: id_pi
        },
        dataType: "json",
        success: function(datos){
            $.toast({
                heading: 'Proceso Terminado',
                text: 'Ingrediente eliminado',
                position: 'bottom-left',
                loaderBg:'#696969',
                icon: 'success',
                hideAfter: 3000, 
                stack: 20
            });
            listarReceta();
        }
    });
}

$('.btn-eliminar').on('click', function(){
    $('.list-ingredientes').css('display','none');
    $("#buscar_ingrediente").val('');
    $('#cant_receta').val('');
    $('#valor_ing').text('0');
});

/* Boton cerrar modal ingredientes */
$('.btn-cerrar-receta').click( function() {
    $('#modal-receta').modal('hide');
    $('#modal-presentacion').modal('show');
});

/* PRESENTACION */

$('#receta_presentacion').on('click', function(event){
    if($('#receta_presentacion').is(':checked')){
        $('#mensaje-ins').css('display','block');
        $('#hidden_receta_presentacion').val(1);
    }else{
        $('#mensaje-ins').css('display','none');
        $('#hidden_receta_presentacion').val(0);
    }
});

$('#stock_presentacion').on('click', function(event){
    if($('#stock_presentacion').is(':checked')){
        
        $('#tp-4').css('display','block');
        $('#tp-4-1').css('display','block');
    }else{
        
        $('#tp-4').css('display','none');
        $('#tp-4-1').css('display','none');
    }
});

$('#impuesto_presentacion').on('click', function(event){
    if($('#impuesto_presentacion').is(':checked')){
        $('#hidden_impuesto_presentacion').val(1);
    }else{
        $('#hidden_impuesto_presentacion').val(0);
    }
});

$('#impuesto_presentacion_compra').on('click', function(event){
    if($('#impuesto_presentacion_compra').is(':checked')){
        $('#hidden_impuesto_presentacion_compra').val(1);
    }else{
        $('#hidden_impuesto_presentacion_compra').val(0);
    }
});

$('#delivery_presentacion').on('click', function(event){
    if($('#delivery_presentacion').is(':checked')){
        $('#hidden_delivery_presentacion').val(1);
        $('#tp-3').css('display','block');
    }else{
        $('#hidden_delivery_presentacion').val(0);
        $('#tp-3').css('display','none');
    }
});

$('#impuesto_icbper').on('click', function(event){
    if($('#impuesto_icbper').is(':checked')){
        $('#hidden_impuesto_icbper').val(1);
    }else{
        $('#hidden_impuesto_icbper').val(0);
    }
});
 
$('#estado_presentacion').on('click', function(event){
    if($('#estado_presentacion').is(':checked')){
        $('#hidden_estado_presentacion').val('a');
    }else{
        $('#hidden_estado_presentacion').val('i');
    }
});

$('#favorito').on('click', function(event){
    if($('#favorito').is(':checked')){
        $('#hidden_favorito').val(1);
    }else{
        $('#hidden_favorito').val(0);
    }
});

/* PRESENTACION */

/* CATEGORIA */
$('#delivery_categoria').on('click', function(event){
    if($('#delivery_categoria').is(':checked')){
        $('#hidden_delivery_categoria').val(1);
    }else{
        $('#hidden_delivery_categoria').val(0);
    }
});

$('#estado_categoria').on('click', function(event){
    if($('#estado_categoria').is(':checked')){
        $('#hidden_estado_categoria').val('a');
    }else{
        $('#hidden_estado_categoria').val('i');
    }
});

$('.btn-categoria-nuevo').click( function() {
    $(".f").removeClass("focused");
    $('.display-categoria-list').hide();
    $('#display-categoria-nuevo').show();
    $('#descripcion_categoria').val('');
    $('#orden_categoria').val('');
    $("#descripcion_categoria").focus();
    $('#id_catg_categoria').val('');
    $('#form-categoria').formValidation('revalidateField', 'descripcion_categoria');
    $('#hidden_delivery_categoria').val(0);
    $('#delivery_categoria').prop('checked', false);
    $('#hidden_estado_categoria').val('a');
    $('#estado_categoria').prop('checked', true);
    $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/productos/default.png');
    $('#imagen').val('default.png');
    $('#wizard-picture-2').val('');
});

$('.btn-categoria-cancelar').click( function() {
    $(".f").removeClass("focused");
    $('.display-categoria-list').show();
    $('#display-categoria-nuevo').hide();
    $('#descripcion_categoria').val('');
    $('#orden_categoria').val('');
    $("#descripcion_categoria").focus();
    $('#id_catg_categoria').val('');
});

/* CATEGORIA */

/* PRODUCTO */
$('#delivery_producto').on('click', function(event){
    if($('#delivery_producto').is(':checked')){
        $('#hidden_delivery_producto').val(1);
    }else{
        $('#hidden_delivery_producto').val(0);
    }
});

$('#stock_limit').on('click', function(event){
    if($('#stock_limit').is(':checked')){
        $('#hidden_stock_limit').val(1);
    }else{
        $('#hidden_stock_limit').val(0);
    }
});

$('#insumo_principal_presentacion').on('click', function(event){
    if($('#insumo_principal_presentacion').is(':checked')){
        $('#hidden_insumo_principal_presentacion').val(1);
    }else{
        $('#hidden_insumo_principal_presentacion').val(0);
    }
});

$('#estado_producto').on('click', function(event){
    if($('#estado_producto').is(':checked')){
        $('#hidden_estado_producto').val('a');
    }else{
        $('#hidden_estado_producto').val('i');
    }
});

$('.btn-nuevo-producto').click( function() {
    $('#id_prod_producto').val('');
    $('#transf').addClass('active');
    $('#ntransf').removeClass('active');
    $("input[name=id_tipo][value='1']").attr("checked",true);
    $("input[name=id_tipo][value='2']").attr("checked",false);
    ComboCatg();
    $('#notas_producto').tagsinput('removeAll');
    $('.bootstrap-tagsinput').css('display','block');
    $('#hidden_delivery_producto').val(0);
    $('#delivery_producto').prop('checked', false);
    $('#hidden_estado_producto').val('a');
    $('#estado_producto').prop('checked', true);
    $('#modal-producto').modal('show');
});

$('#modal-producto').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-producto').formValidation('resetForm', true);
    $("#notas_producto").val('');
    $("#id_areap_producto").val('').selectpicker('refresh');
    $('#receta_presentacion').removeAttr('checked');
    $('#stock_presentacion').removeAttr('checked');
});

$('.btn-importar-producto').click( function() {
    $('#id_prod_producto').val('');
    $('#transf').addClass('active');
    $('#ntransf').removeClass('active');
    $("input[name=id_tipo][value='1']").attr("checked",true);
    $("input[name=id_tipo][value='2']").attr("checked",false);
    ComboCatg();
    $('#notas_producto').tagsinput('removeAll');
    $('.bootstrap-tagsinput').css('display','block');
    $('#hidden_delivery_producto').val(0);
    $('#delivery_producto').prop('checked', false);
    $('#hidden_estado_producto').val('a');
    $('#estado_producto').prop('checked', true);
    $('#modal-import').modal('show');
});
$('#modal-import').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#upfile').formValidation('resetForm', true);
});
/* PRODUCTO */

$('#presentacion_presentacion').keyup(function(){
    var abrev_pres = ($(this).val().charAt(0)+''+$(this).val().charAt(1)+''+$(this).val().charAt(2)).toUpperCase();
    var abrev_prod = ($('#nomb_pres').text().charAt(0)+''+$('#nomb_pres').text().charAt(1)).toUpperCase();
    var abrev_prec = Math.floor($('#precio_presentacion').val());
    $("#cod_prod_presentacion").val(abrev_prod+''+abrev_pres+''+abrev_prec);
});

$('#precio_presentacion').keyup(function(){
    var abrev_pres = ($('#presentacion_presentacion').val().charAt(0)+''+$('#presentacion_presentacion').val().charAt(1)+''+$('#nombre_pres').val().charAt(2)).toUpperCase();
    var abrev_prod = ($('#nomb_pres').text().charAt(0)+''+$('#nomb_pres').text().charAt(1)).toUpperCase();
    var abrev_prec = Math.floor($(this).val());
    $("#cod_prod_presentacion").val(abrev_prod+''+abrev_pres+''+abrev_prec);
});

if($("#multiples_precios").val() == 1){
    $('.multiples_precios').css("display", "block");
}


$(document).ready(function(){
    $(".add-row").click(function(){
        var nombre = $("#nombre").val();
        var precio = parseFloat($("#precio").val());
        precio = parseFloat(precio);
        if (nombre == '' || precio == '' || nombre == null || precio == null  || isNaN(precio)) {
            alert('Ingrese los datos requeridos')
            return false;
        }

        var data = "\
        <tr>\
            <td>" + nombre + "</td>\
            <td>" + precio.toFixed(2) + "</td>\
            <td class='text-center'><button class='btn btn-outline-danger btn-sm' type='button' onclick='borrar_(this)'><i class='fa fa-trash text-danger'></i></button></td>\
        </tr>";
        $(".tb_precios tbody").append(data);
        limpiarInputPrecio()
    });

    $(".delete-row").click(function(){
        $(".tb_precios tbody").find('input[name="record"]').each(function(){
          if($(this).is(":checked")){
                $(this).parents("tr").remove();
            }
        });
    });
});

var borrar_ = function(row){
    $(row).parents(".tb_precios tbody tr").remove();
}

var limpiarInputPrecio = function(row){
    $('#nombre').val('')
    $('#precio').val('')
}


$('#guardar').click(function(){

    var $objCuerpoTabla=$(".tb_precios").children().prev().parent();

    if ($('#id_pres_presentacion').val() == '') {
        alert("Debe guardar el producto para poder asignar precios")
        return false;
    }

    var objDatosColumnatotal = [];

    $objCuerpoTabla.find("tbody tr").each(function(){
        objDatosColumnatotal.push({nombre: $(this).find('td').eq(0).html(), precio: $(this).find('td').eq(1).html(), id_pres: $('#id_pres_presentacion').val()})
        $(this).css("background-color", "#ECF8E0");
    });


    if (objDatosColumnatotal.length > 0) {
        $.ajax({
                data:  {'data':objDatosColumnatotal},
                url:   $('#url').val()+'ajuste/producto_pres_precios_crud',
                type:  'post',
                beforeSend: function () {
                    $('#procesoGuardarPrecio').css("display", "block");
                    $('#procesoGuardarPrecio').html('<div class="alert alert-warning" role="alert"><div class="spinner-border text-success" role="status"><span class="visually-hidden"></span></div><b>Guardando precios...</b></div>')
                        // alert("ocurrio un probl")
                },
                success:  function (response) { //una vez que el archivo recibe el request lo procesa y lo devuel
                    $('#procesoGuardarPrecio').html('<div class="alert alert-warning" role="alert"><b>Precios guardados con exito.</b></div>')
                }
        });
    }else{
        alert("Debe ingresar un producto para poder guardar.")
    }
     
});

