
  const API_URL = 'http://localhost/resultado-final/Database/DataBase.php';
    const Img_URL = 'https://pale.tufacturaya.com/restaurantepro/facturacion/public/images/productos/';
    //API DE POLLERIA
    let categoriasUnicas = [];
    let productosPolleria = [];
async function fetchDataAndLogToConsole() {
    try {
        console.log("Iniciando solicitud a la API...");
        
        const response = await fetch(API_URL);
        const text = await response.text();
        
        try {
            const data = JSON.parse(text);
            productosPolleria = data;
            console.log(productosPolleria)
            cargarProductos(productosPolleria);

            categoriasUnicas = [...new Set(data.map(item => item.nombre_producto))];
            console.log("Categorías únicas:", categoriasUnicas);
           MenuBarra(categoriasUnicas);

            if (data.error) {
                console.error("Error del servidor:", data.error);
                return;
            }
            
            if (data.warning) {
                console.warn(data.warning);
                return;
            }
                       
        } catch (parseError) {
            console.error("Error al parsear JSON:", parseError);
            console.error("Respuesta del servidor:", text);
        }
        
    } catch (error) {
        console.error("Error en la solicitud:", error);
    }
}

fetchDataAndLogToConsole();
//FIN DE API POLLERIA.
function MenuBarra(categoriasUnicas) {
  const menu = document.querySelector(".menu");
  menu.innerHTML = ""; // Limpiar menú anterior

  // Crear botón "Todos los productos"
  const liTodos = document.createElement("li");
  liTodos.innerHTML = `
    <button id="todos" class="boton-menu boton-categoria active">
      <i class="bi bi-hand-index-thumb-fill"></i> Todos los productos
    </button>
  `;
  menu.appendChild(liTodos);

  // Crear botones para cada categoría
  categoriasUnicas.forEach(categoria => {
    const li = document.createElement("li");
    li.innerHTML = `
      <button id="${categoria}" class="boton-menu boton-categoria">
        <i class="bi bi-hand-index-thumb"></i> ${categoria}
      </button>
    `;
    menu.appendChild(li);
  });

  // Agregar botón Carrito y Atrás al final
 

  //
  const botonesCategorias = document.querySelectorAll(".boton-categoria");

  // 🔗 Asigna el evento click a todos los botones actualizados
  botonesCategorias.forEach(boton => {
    boton.addEventListener("click", (e) => {
      console.log("Botón de categoría clickeado:");
      console.log(botonesCategorias);

      // Quitar clase "active" de todos
      botonesCategorias.forEach(boton => boton.classList.remove("active"));

      // Agregar clase "active" al actual
      e.currentTarget.classList.add("active");
      console.log("el target clickeado es :")
      console.log(e.currentTarget.id);
      // el id lso bototnes debe ser igual a la json
const productosBoton = productosPolleria.filter(producto => producto.nombre_producto === e.currentTarget.id);
console.log(productosBoton)
if (productosBoton.length > 0) {
  tituloPrincipal.innerText = productosBoton[0].nombre_producto;
  cargarProductos(productosBoton);
} else {
  tituloPrincipal.innerText = "Todos los productos";
  cargarProductos(productosPolleria);
}

    });
  });

}

const contenedorProductos = document.querySelector("#contenedor-productos");
const botonesCategorias = document.querySelectorAll(".boton-categoria");
const tituloPrincipal = document.querySelector("#titulo-principal");
let botonesAgregar = document.querySelectorAll(".producto-agregar");
const numerito = document.querySelector("#numerito");


botonesCategorias.forEach(boton => boton.addEventListener("click", () => {
    aside.classList.remove("aside-visible");
}))


function cargarProductos(productosElegidos) {

    contenedorProductos.innerHTML = "";

    productosElegidos.forEach(producto => {

        const div = document.createElement("div");
        div.classList.add("producto");
        div.innerHTML = `
            <img class="producto-imagen" src="${Img_URL + producto.archivo_imagen}" alt="${producto.titulo}">
            <div class="producto-detalles">
                <h3 class="producto-titulo">${producto.presentacion}</h3>
                <p class="producto-precio">S/${producto.precio}</p>
                <button class="producto-agregar" id="${producto.presentacion}">Agregar</button>
            </div>
        `;

        contenedorProductos.append(div);
    })

    actualizarBotonesAgregar();


    
}





function actualizarBotonesAgregar() {
    botonesAgregar = document.querySelectorAll(".producto-agregar");

    botonesAgregar.forEach(boton => {
        boton.addEventListener("click", agregarAlCarrito);
    });
}
let productosEnCarrito;

let productosEnCarritoLS = localStorage.getItem("productos-en-carrito");

if (productosEnCarritoLS) {
    productosEnCarrito = JSON.parse(productosEnCarritoLS);
    actualizarNumerito();
} else {
    productosEnCarrito = [];
}

function agregarAlCarrito(e) {

    Toastify({
        text: "Producto agregado",
        duration: 3000,
        close: true,
        gravity: "top", // `top` or `bottom`
        position: "right", // `left`, `center` or `right`
        stopOnFocus: true, // Prevents dismissing of toast on hover
        style: {
          background: "linear-gradient(to right, #4b33a8, #785ce9)",
          borderRadius: "2rem",
          textTransform: "uppercase",
          fontSize: ".75rem"
        },
        offset: {
            x: '1.5rem', // horizontal axis - can be a number or a string indicating unity. eg: '2em'
            y: '1.5rem' // vertical axis - can be a number or a string indicating unity. eg: '2em'
          },
        onClick: function(){} // Callback after click
      }).showToast();

    const idBoton = e.currentTarget.id;
    console.log("Target del button agregar al carrito:")
    console.log(idBoton)
    const productoAgregado = productosPolleria.find(producto => producto.presentacion === idBoton);

    if(productosEnCarrito.some(producto => producto.presentacion === idBoton)) {
        const index = productosEnCarrito.findIndex(producto => producto.presentacion === idBoton);
        productosEnCarrito[index].cantidad++;
    } else {
        productoAgregado.cantidad = 1;
        productosEnCarrito.push(productoAgregado);
    }

    actualizarNumerito();

    localStorage.setItem("productos-en-carrito", JSON.stringify(productosEnCarrito));
}

function actualizarNumerito() {
    let nuevoNumerito = productosEnCarrito.reduce((acc, producto) => acc + producto.cantidad, 0);
    numerito.innerText = nuevoNumerito;
}